
/*

 Plus / Minus / Cross Button

 The button flashes on click, and can be disabled using the active message.
 
 arguments: shape (0 - minus / 1 - plus / 2 - cross) labelred labelgreen labelblue arrowred arrowgreen arrowblue bgred bggreen bgblue font fontsize roundness padding
 
 (fontsize is specified as a percentage of height 0.-1.)

*/

outlets = 1;

sketch.default2d();

var m_text = " ";
var m_brgb = [1,1,1];
var m_frgb = [0.1,0.1,0.1];
var m_rgb2 = [1,1,1];
var m_rgb3 = [0.75,0.75,0.75];
var m_rgb4 = [0.490196,0.705882,1];
var m_active = 1;
var m_clicked = 0;
var m_flash_off = new Task(flashoff);
var m_flash_time = 100;

var m_font = "Sans Serif";  // Geneva on Mac, Arial on PC
var m_font_size = 0.7;		// relative to height
var m_round = 1;
var m_padding = 0.15;
var m_shape = 1;

// Process arguments

if (jsarguments.length > 1)
	shape(jsarguments[1]);
if (jsarguments.length > 2)
	m_frgb[0] = jsarguments[2]/255.;
if (jsarguments.length > 3)
	m_frgb[1] = jsarguments[3]/255.;
if (jsarguments.length > 4)
	m_frgb[2] = jsarguments[4]/255.;
if (jsarguments.length > 5)
	m_rgb2[0] = jsarguments[5]/255.;
if (jsarguments.length > 6)
	m_rgb2[1] = jsarguments[6]/255.;
if (jsarguments.length > 7)
	m_rgb2[2] = jsarguments[7]/255.;
if (jsarguments.length > 8)
	m_brgb[0] = jsarguments[8]/255.;
if (jsarguments.length > 9)
	m_brgb[1] = jsarguments[9]/255.;
if (jsarguments.length > 10)
	m_brgb[2] = jsarguments[10]/255.;
if (jsarguments.length > 11)
	m_font = jsarguments[11];
if (jsarguments.length > 12)
	m_font_size = jsarguments[12];
if (jsarguments.length > 13)
	m_round = jsarguments[13];
if (jsarguments.length > 14)
	m_padding = jsarguments[14];


draw();


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////// Draw routines ////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


function draw()
{
	var str,width,height,aspect;
	
	height = box.rect[3] - box.rect[1]; 
	width = box.rect[2] - box.rect[0]; 
	aspect = width/height;
	
	with (sketch) 
	{
		// Erase background
		
		glclearcolor(m_brgb);
		glclear();
		
		shapeorient (0, 0, 0);
		if(!m_active) glcolor(m_rgb3);
		else 
		{
			if (m_clicked) glcolor(m_rgb4);
			else glcolor(m_frgb);
		}
		
		moveto(0, 0);
		roundedplane(m_round, (aspect-m_padding),1-m_padding);
		
		glcolor(m_rgb2);
		moveto(0, 0);
		if (m_shape > 1) 
			shapeorient (0, 0, 45);
		if (m_shape) 
			plane (0.1, 0.5);
		if (m_shape > 1) 
			shapeorient (0, 0, 45);
		moveto(0, 0);
		plane (0.5, 0.1);
	}
}


function flashoff()
{
	m_clicked = 0;
	draw();
	refresh();
} flashoff.local = 1;


function bang()
{
	m_clicked = 1;
	m_flash_off.schedule(m_flash_time);
	draw();
	refresh();
	outlet(0,"bang");
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////// User message interaction /////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


function round(v)
{
	m_round = v;
	draw();
	refresh();
}


function frgb(r,g,b)
{
	m_frgb[0] = r/255.;
	m_frgb[1] = g/255.;
	m_frgb[2] = b/255.;
	draw();
	refresh();
}


function brgb(r,g,b)
{
	m_brgb[0] = r/255.;
	m_brgb[1] = g/255.;
	m_brgb[2] = b/255.;
	draw();
	refresh();
}


function rgb2(r,g,b)
{
	m_rgb2[0] = r/255.;
	m_rgb2[1] = g/255.;
	m_rgb2[2] = b/255.;
	draw();
	refresh();
}


function rgb3(r,g,b)
{
	m_rgb3[0] = r/255.;
	m_rgb3[1] = g/255.;
	m_rgb3[2] = b/255.;
	draw();
	refresh();
}


function rgb4(r,g,b)
{
	m_rgb4[0] = r/255.;
	m_rgb4[1] = g/255.;
	m_rgb4[2] = b/255.;
	draw();
	refresh();
}


function shape(v)
{
	if (v) 
		m_shape = v;
	else 
		m_shape = 0;
	draw();
	refresh();
}


function flashtime(v)
{
	m_flash_time = v;
}


function active(v)
{
	if (v) 
		m_active = 1;
	else 
		m_active = 0;
	draw();
	refresh();
}


function fsaa(v)
{
	sketch.fsaa = v;
	draw();
	refresh();
}


function text(v)
{
	m_text = v.toString();
	draw();
	refresh();
}


function font(v)
{
	m_font = v.toString();
	draw();
	refresh();
}


function fontsize(v)
{
	m_font_size = v;
	draw();
	refresh();
}


function padding(v)
{
	m_padding = v;
	draw();
	refresh();
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////// User mouse interaction //////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


function onclick(x,y,but,cmd,shift,capslock,option,ctrl)
{
	ondrag(x,y,but,cmd,shift,capslock,option,ctrl);
}
onclick.local = 1; //private


function ondrag(x,y,but,cmd,shift,capslock,option,ctrl)
{
	var width = box.rect[2] - box.rect[0]; 
	var height = box.rect[3] - box.rect[1]; 

	idleon = 0;
	if (x>0 && x<width && y>0 && y<height) inbox = 1;	
	else inbox = 0;

	if ((!but && inbox) && m_active) 
	{
		bang();
	} 
	else 
	{
		if (m_active) m_clicked = inbox;
		draw();
		refresh();
	}
}
ondrag.local = 1; //private. 


function onresize(w,h)
{
	draw();
	refresh();
}
onresize.local = 1; //private

